/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public final class FileError
extends LispError {
    public FileError(LispObject initArgs) {
        super(StandardClass.FILE_ERROR);
        if (initArgs instanceof Cons) {
            this.initialize(initArgs);
        } else {
            this.setPathname(initArgs);
        }
    }

    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        LispObject pathname = Lisp.NIL;
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.PATHNAME) {
                pathname = initArgs.car();
                break;
            }
            initArgs = initArgs.cdr();
        }
        this.setPathname(pathname);
    }

    public FileError(String message) {
        super(StandardClass.FILE_ERROR);
        this.setFormatControl(message);
        this.setFormatArguments(Lisp.NIL);
        this.setPathname(Lisp.NIL);
    }

    public FileError(String message, LispObject pathname) {
        super(StandardClass.FILE_ERROR);
        this.setFormatControl(message);
        this.setFormatArguments(Lisp.NIL);
        this.setPathname(pathname);
    }

    public LispObject getPathname() {
        return this.getInstanceSlotValue(Symbol.PATHNAME);
    }

    private void setPathname(LispObject pathname) {
        this.setInstanceSlotValue(Symbol.PATHNAME, pathname);
    }

    public LispObject typeOf() {
        return Symbol.FILE_ERROR;
    }

    public LispObject classOf() {
        return StandardClass.FILE_ERROR;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.FILE_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.FILE_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }
}

