/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharHashMap<T> {
    public final T[] constants;
    public final T NULL;
    static final int CACHE_SIZE = 256;
    final HashMap<Character, T> backing;

    public CharHashMap(Class componentType, T def) {
        this.NULL = def;
        this.constants = (Object[])Array.newInstance(componentType, 256);
        Arrays.fill(this.constants, this.NULL);
        this.backing = new HashMap();
    }

    public Object clone() {
        CharHashMap<T> n = new CharHashMap<T>(this.constants.getClass().getComponentType(), this.NULL);
        System.arraycopy(this.constants, 0, n.constants, 0, 256);
        n.backing.putAll(this.backing);
        return n;
    }

    public T get(char key) {
        if (key < '\u0100') {
            return this.constants[key];
        }
        T value = this.backing.get(Character.valueOf(key));
        return value == null ? this.NULL : value;
    }

    public void clear() {
        Arrays.fill(this.constants, this.NULL);
        this.backing.clear();
    }

    public T put(char key, T value) {
        if (key < '\u0100') {
            T old = this.constants[key];
            this.constants[key] = value;
            return old;
        }
        return this.backing.put(Character.valueOf(key), value);
    }

    public Iterator<Character> getCharIterator() {
        return new Iterator<Character>(){
            final Iterator<Character> carIt;
            int charNum;
            {
                this.carIt = CharHashMap.this.backing.keySet().iterator();
                this.charNum = -1;
            }

            @Override
            public boolean hasNext() {
                if (this.charNum < 256) {
                    return true;
                }
                return this.carIt.hasNext();
            }

            @Override
            public Character next() {
                if (this.charNum < 256) {
                    return Character.valueOf((char)(++this.charNum));
                }
                return this.carIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

